package djextrafunc

import (
	"djconstants"
	"djdb"
	//  "djlogger"
	"djredis"
	"errors"
	"fmt"
	"math"
	"math/rand"
	"net"
	"reflect"
	"strconv"
	"strings"
	"time"
)

// Function for getting DSP id from db
func GetDspId(dsp_name string, key string, bid int, redisClient *djredis.RedisClient) (int, string, float64, string, string, string) {
	type valueEx struct {
		Dsp_id            int
		Dmp_pixel         string
		Admin_share       float64
		WebResponseType   string
		VideoResponseType string
		DS                string
	}
	var where string
	if bid != 0 {
		where = "id=" + strconv.Itoa(bid)
			dsp_name = "dsp"+ strconv.Itoa(bid) 

	} else {
		where = "dsp_portal_name='" + dsp_name + "'"
		where += " and auth_key='" + key + "'"
	}
		
	
	v := &valueEx{}

	//  errs := redisClient.GetKey(dsp_name, v)
	

	// 		 fmt.Println(dsp_name);

	//  if errs != nil {
	// 	 djlogger.Log.Println("Key expired or error in getting redis key: ", errs.Error())
	//  }
	// fmt.Println("dsp :",v)
	//  if v != nil && errs == nil {
	// 	fmt.Println("Fetching dsp data from redis")
	// 	 return v.Dsp_id, v.Dmp_pixel, v.Admin_share, v.WebResponseType, v.VideoResponseType, v.DS
	//  } else {
		
			
djdb.DbQueryRow("SELECT id,admin_share,web_response_type,video_response_type,digital_signature from "+djconstants.TablePrefix+"dj_dsp where "+where+" and status='1'").Scan(&v.Dsp_id, &v.Admin_share, &v.WebResponseType, &v.VideoResponseType, &v.DS)

		//  errs := redisClient.SetKey(dsp_name, &valueEx{Dsp_id: v.Dsp_id, Dmp_pixel: v.Dmp_pixel, Admin_share: v.Admin_share, WebResponseType: v.WebResponseType, VideoResponseType: v.VideoResponseType, DS: v.DS}, time.Minute*djconstants.RedisExpInMin)
		//  errs = redisClient.SetKey("dsp"+ strconv.Itoa(v.Dsp_id), &valueEx{Dsp_id: v.Dsp_id, Dmp_pixel: v.Dmp_pixel, Admin_share: v.Admin_share, WebResponseType: v.WebResponseType, VideoResponseType: v.VideoResponseType, DS: v.DS}, time.Minute*djconstants.RedisExpInMin)
		//  if errs != nil { 
		// 	 djlogger.Log.Println("Error in setting redis key: ", errs.Error())
		//  }

		return v.Dsp_id, v.Dmp_pixel, v.Admin_share, v.WebResponseType, v.VideoResponseType, v.DS
	//  }
}

// Function for coverting float to string
func FloatToString(input_num float64) string {
	return strconv.FormatFloat(input_num, 'f', 6, 64)
}

// Function for coverting float to string
func StringToFloat(str string, bit int) float64 {
	if flt, err := strconv.ParseFloat(str, bit); err == nil {
		return flt
	}
	return 0
}

// Function for replacing Nth character in a string
func ReplaceNth(s, old, old1, new string, new1 string, n int) string {
	if old1 != "" && new1 != "" {
		s = strings.Replace(s, old1, new1, -1)
	}
	i := 0
	for m := 1; m <= n; m++ {
		x := strings.Index(s[i:], old)
		if x < 0 {
			break
		}
		i += x
		if m == n {
			if old1 != "" && new1 != "" {
				u := s[:i] + new + s[i+len(old):]
				return u[:strings.IndexByte(u, ' ')]
			}
			return s[:i] + new + s[i+len(old):]
		}
		i += len(old)
	}
	return s
}

// Function for checking value in an array
func In_array(val interface{}, array interface{}) (exists bool) {
	exists = false
	switch reflect.TypeOf(array).Kind() {
	case reflect.Slice:
		s := reflect.ValueOf(array)
		for i := 0; i < s.Len(); i++ {
			if reflect.DeepEqual(val, s.Index(i).Interface()) == true {
				exists = true
				return
			}
		}
	}
	return
}

// Function for checking both arrays are equal
func CheckEqual(a, b []string) bool {
	// If one is nil, the other must also be nil.
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for i := range a {
		if a[i] != b[i] {
			return false
		}
	}
	return true
}

// Function for generating random token
func RandToken(len int) string {
	b := make([]byte, len)
	rand.Read(b)
	return fmt.Sprintf("%x", b)
}

// Function for coverting array to string
func ArrayToString(a interface{}, delim string) string {
	return strings.Trim(strings.Replace(fmt.Sprint(a), " ", delim, -1), "[]")
}

// Function for generating random number
func RandNumber(len int) int {
	l := "1"
	for i := 0; i < len; i++ {
		l += "0"
	}
	stri, _ := strconv.Atoi(l)
	rand.Seed(time.Now().UnixNano())
	return rand.Intn(stri)
}

// Function for getting vast type
func Vasttype(ctype interface{}) (interface{}, interface{}, interface{}) {
	var ctypeArr, inWrap, ovWrap []interface{}
	switch reflect.TypeOf(ctype).Kind() {
	case reflect.Slice:
		s := reflect.ValueOf(ctype)
		for i := 0; i < s.Len(); i++ {
			if s.Index(i).Interface() == 2 {
				ctypeArr = append(ctypeArr, 1)
				inWrap = append(inWrap, 1)
				ovWrap = append(ovWrap, "image_overlay")
			}
			if s.Index(i).Interface() == 3 {
				ctypeArr = append(ctypeArr, 2)
				inWrap = append(inWrap, 1)
				ovWrap = append(ovWrap, "image_overlay")
			}
			if s.Index(i).Interface() == 5 {
				ctypeArr = append(ctypeArr, 1)
				inWrap = append(inWrap, 2)
				ovWrap = append(ovWrap, "VAST_OVERLAY_FORMAT_WRAPPER")
			}
			if s.Index(i).Interface() == 6 {
				ctypeArr = append(ctypeArr, 2)
				inWrap = append(inWrap, 2)
				ovWrap = append(ovWrap, "VAST_OVERLAY_FORMAT_WRAPPER")
			}
			if s.Index(i).Interface() == 7 {
				ctypeArr = append(ctypeArr, 3)
				inWrap = append(inWrap, 1)
				ovWrap = append(ovWrap, "image_overlay")
			}
			if s.Index(i).Interface() == 8 {
				ctypeArr = append(ctypeArr, 3)
				inWrap = append(inWrap, 2)
				ovWrap = append(ovWrap, "VAST_OVERLAY_FORMAT_WRAPPER")
			}
			if s.Index(i).Interface() == 11 {
				ctypeArr = append(ctypeArr, 4)
				inWrap = append(inWrap, 1)
				ovWrap = append(ovWrap, "image_overlay")
			}
			if s.Index(i).Interface() == 12 {
				ctypeArr = append(ctypeArr, 4)
				inWrap = append(inWrap, 2)
				ovWrap = append(ovWrap, "VAST_OVERLAY_FORMAT_WRAPPER")
			}
		}
	}
	return RemoveDuplicates(ctypeArr), RemoveDuplicates(inWrap), RemoveDuplicates(ovWrap)
}

// Function for removing duplicate values of array
func RemoveDuplicates(elements []interface{}) []interface{} {
	var result []interface{}
	// Use map to record duplicates as we find them.
	encountered := map[interface{}]bool{}
	switch reflect.TypeOf(elements).Kind() {
	case reflect.Slice:
		s := reflect.ValueOf(elements)
		for i := 0; i < s.Len(); i++ {
			if encountered[s.Index(i).Interface()] == true {
				// Do not add duplicate.
			} else {
				// Record this element as an encountered element.
				encountered[s.Index(i).Interface()] = true
				// Append to result slice.
				result = append(result, s.Index(i).Interface())
			}
		}
	}
	// Return the new slice.
	return result
}

// Function for converting second to time format
func SecondsToTime(input int) (result string) {
	if input < 86400 {
		seconds := input % (60 * 60 * 24)
		hours := math.Floor(float64(seconds) / 60 / 60)
		seconds = input % (60 * 60)
		minutes := math.Floor(float64(seconds) / 60)
		seconds = input % 60
		if hours > 0 {
			result = AddZeros(int(hours)) + ":" + AddZeros(int(minutes)) + ":" + AddZeros(int(seconds))
		} else if minutes > 0 {
			result = "00:" + AddZeros(int(minutes)) + ":" + AddZeros(int(seconds))
		} else {
			result = "00:00:" + AddZeros(int(seconds))
		}
	}
	return
}

// Function for adding extra zeros
func AddZeros(count int) (result string) {
	if len(strconv.Itoa(count)) == 1 {
		result = "0" + strconv.Itoa(count)
	} else {
		result = strconv.Itoa(count)
	}
	return
}

// Function for getting application IP
func ExternalIP() (string, error) {
	ifaces, err := net.Interfaces()
	if err != nil {
		return "", err
	}
	for _, iface := range ifaces {
		if iface.Flags&net.FlagUp == 0 {
			continue // interface down
		}
		if iface.Flags&net.FlagLoopback != 0 {
			continue // loopback interface
		}
		addrs, err := iface.Addrs()
		if err != nil {
			return "", err
		}
		for _, addr := range addrs {
			var ip net.IP
			switch v := addr.(type) {
			case *net.IPNet:
				ip = v.IP
			case *net.IPAddr:
				ip = v.IP
			}
			if ip == nil || ip.IsLoopback() {
				continue
			}
			ip = ip.To4()
			if ip == nil {
				continue // not an ipv4 address
			}
			return ip.String(), nil
		}
	}
	return "", errors.New("are you connected to the network?")
}

// Function for getting image mime type
func ImageMimeType(array []string) string {
	var (
		mimetypeArr []string
		mimetype    string
	)
	if len(array) > 0 {
		for _, v := range array {
			if "image/jpg" == v {
				mimetype = "jpg"
			} else if "image/gif" == v {
				mimetype = "gif"
			} else if "image/jpeg" == v {
				mimetype = "jpeg"
			} else if "image/png" == v {
				mimetype = "png"
			}
			mimetypeArr = append(mimetypeArr, mimetype)
		}
	} else {
		mimetype = "jpg,gif,jpeg,png"
		return mimetype
	}
	return ArrayToString(mimetypeArr, ",")
}
